#! /usr/bin/perl

use strict;
use DBI;

# MYSQL CONFIG VARIABLES
my $host = "localhost";
my $db = "Pharma";
my $driver = "DBI:mysql:$db:$host";
my $user = "test";
my $pw = "test";

# PERL CONNECT()
my $dbh = DBI->connect($driver, $user, $pw)|| die "$DBI::errstr\n";
#my $dbh = DBI->connect( "dbi:ODBC:Pharmadaten",'','') || die "$DBI::errstr\n";

my $tabname = "";
my @spalte = ();
my @sptyp  = ();
my @splen  = ();
my $start  = -1;

sub decode
  {
  my $s = $_[0];
		$s =~ s/\\A25//g;
		$s =~ s/\\A29//g;
    $s =~ s/\\a22//g;
    $s =~ s/\\a23//g;
    $s =~ s/\\a24//g;
    $s =~ s/\\a25//g;
    $s =~ s/\\a29//g;
    $s =~ s/\\a33//g;
    $s =~ s/\\a63/a/g;
    $s =~ s/\\b63//g;
    $s =~ s/\\C49//g;
    $s =~ s/\\c22/c/g;
    $s =~ s/\\c49//g;
    $s =~ s/\\D63/?/g;
    $s =~ s/\\d63/d/g;
    $s =~ s/\\E22//g;
    $s =~ s/\\E33/E/g;
    $s =~ s/\\E63/?/g;
    $s =~ s/\\e22//g;
    $s =~ s/\\e23//g;
    $s =~ s/\\e24//g;
    $s =~ s/\\e25//g;
    $s =~ s/\\e63/e/g;
    $s =~ s/\\g63/Y/g;
    $s =~ s/\\H63/T/g;
    $s =~ s/\\I25//g;
    $s =~ s/\\i22//g;
    $s =~ s/\\i23//g;
    $s =~ s/\\i24//g;
    $s =~ s/\\i25//g;
    $s =~ s/\\J63/H/g;
    $s =~ s/\\j63/?/g;
    $s =~ s/\\k63/?/g;
    $s =~ s/\\L63/?/g;
    $s =~ s/\\I63/?/g;
    $s =~ s/\\M33/M/g;
    $s =~ s/\\m33/m/g;
    $s =~ s/\\m63//g;
    $s =~ s/\\N26//g;
    $s =~ s/\\n26//g;
    $s =~ s/\\n63/?/g;
    $s =~ s/\\O25//g;
    $s =~ s/\\o22//g;
    $s =~ s/\\o23//g;
    $s =~ s/\\o24//g;
    $s =~ s/\\o25//g;
    $s =~ s/\\o35/o/g;
    $s =~ s/\\o42//g;
    $s =~ s/\\o63/d/g;
    $s =~ s/\\p63/p/g;
    $s =~ s/\\s39//g;
    $s =~ s/\\s63/s/g;
    $s =~ s/\\t63/T/g;
    $s =~ s/\\U25//g;
    $s =~ s/\\u22//g;
    $s =~ s/\\u23//g;
    $s =~ s/\\u24//g;
    $s =~ s/\\u25//g;
    $s =~ s/\\W63/O/g;
    $s =~ s/\\w63/?/g;
    $s =~ s/\\x63/X/g;
    $s =~ s/\\y25//g;
    $s =~ s/\\y63/?/g;
    $s =~ s/\\z63/?/g;
    $s =~ s/\\321/,/g;
    $s =~ s/\\323/:/g;
    $s =~ s/\\324/!/g;
    $s =~ s/\\325/?/g;
    $s =~ s/\\326/-/g;
    $s =~ s/\\327/=/g;
    $s =~ s/\\328/#/g;
    $s =~ s/\\329//g;
    $s =~ s/\\330//g;
    $s =~ s/\\333/#/g;
    $s =~ s/\\340/*/g;
    $s =~ s/\\341/|/g;
    $s =~ s/\\344//g;
    $s =~ s/\\345/?/g;
    $s =~ s/\\346//g;
    $s =~ s/\\347//g;
    $s =~ s/\\348//g;
    $s =~ s/\\351/?/g;
    $s =~ s/\\360/+/g;
    $s =~ s/\\361/&/g;
    $s =~ s/\\362/*/g;
    $s =~ s/\\363//g;
    $s =~ s/\\364/#/g;
    $s =~ s/\\365/_/g;
    $s =~ s/\\367/#/g;
    $s =~ s/\\372/#/g;
    $s =~ s/\\375/#/g;
    $s =~ s/\\380//g;
    $s =~ s/\\420/(/g;
    $s =~ s/\\421/)/g;
    $s =~ s/\\422/[/g;
    $s =~ s/\\423/]/g;
    $s =~ s/\\424/{/g;
    $s =~ s/\\425/}/g;
    $s =~ s/\\426/</g;
    $s =~ s/\\427/>/g;
    $s =~ s/\\428//g;
    $s =~ s/\\429//g;
    $s =~ s/\\430//g;
    $s =~ s/\\431//g;
    $s =~ s/\\432/?/g;
    $s =~ s/\\435/?/g;
    $s =~ s/\\460//g;
    $s =~ s/\\462/#/g;
    $s =~ s/\\463/<->/g;
    $s =~ s/\\465/~/g;
    $s =~ s/\\466/?/g;
    $s =~ s/\\467/?/g;
    $s =~ s/\\473//g;
    $s =~ s/\\520/<=/g;
    $s =~ s/\\521/>=/g;
    $s =~ s/\\535/?/g;
    $s =~ s/\\565/#/g;
    $s =~ s/\\900//g;
  return $s;
  }

sub process_satz
  {
  my $sref = $_[0];
  
  if( $sref->[0] eq "K" )
    {
    $tabname = $sref->[6]; 
    $tabname =~ s/-/_/g;
    }
  elsif( $sref->[0] eq "F" ) 
    {
    push @spalte, $sref->[2];
    #push @sptyp ,( $sref->[7] eq ~/NU1/ ?"N":"S");
    	
    	push @sptyp ,($sref->[7] eq ("NU1" or "NU2" or "NU3" or "PNH" or "PZN" or "IKZ" or "GRU" or "FLA" or "GK1" or "DTA")?"N":"S" );
    	
    	push @splen , $sref->[6];
    }
  }

sub process_file
  {
  my $file = $_[0];
  
  $tabname = "";
  @spalte = ();
  @sptyp  = ();
  @splen  = ();
  $start = -1;

  open IN, "<", $file;
  my $last=-1; my @satz = ();
  while(<IN>)
    {
    chomp $_;
    my $line = substr($_, 0, 2);
    my $content = substr($_, 2);
    if( $line<=$last )
      {
      process_satz( \@satz );
      @satz=();
      }
    $satz[$line] = decode($content);
    $last = $line;
    }
  }
  
sub create_table
  {
  my $table = $_[0];

  process_file( $table );

  my $sql = "create table ".$tabname." (";
  for( my $i=0; $i<@spalte; $i++ )
  {
    if( $spalte[$i] eq "Text" ) { $spalte[$i] = "Text1"; }
    if( $sptyp[$i] eq "N" && $splen[$i]>9 )
      {
      $sql .= $spalte[$i]." double, ";
      }
    elsif( $sptyp[$i] eq "N" )
      {
      $sql .= $spalte[$i]." integer, ";
      }
    elsif( $splen[$i]>250 )
    # elsif( $sptyp[$i] eq "S" )
      {
      $sql .= $spalte[$i]." text, ";
      }
    else
    		{
    		if ($splen[$i] <1)
    		{
    		$sql .= $spalte[$i]." text, ";
    		}
    else  
       	{
      	$sql .= $spalte[$i]." varchar(".$splen[$i]."), ";
      	}
    	}
    }
  $sql =~ s/, $//;
  $sql .= ")";
  print $sql."\n";
  my $sth = $dbh->prepare( $sql );
  $sth->execute();
  }

opendir DIR, ".";
my @files = grep { /\.GES$/ && -f "$_" } readdir(DIR);
closedir DIR;

foreach my $file (@files)
  {
  create_table( $file );
  }


$dbh->disconnect;